/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.core;

import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.montoyo.wd.entity.TileEntityKeyboard;
import net.montoyo.wd.entity.TileEntityRCtrl;
import net.montoyo.wd.entity.TileEntityRedCtrl;
import net.montoyo.wd.entity.TileEntityServer;
import net.montoyo.wd.init.BlockInit;
import org.jetbrains.annotations.NotNull;

public enum DefaultPeripheral implements StringRepresentable
{
    KEYBOARD("keyboard", "Keyboard", (BlockEntityType.BlockEntitySupplier<? extends BlockEntity>)((BlockEntityType.BlockEntitySupplier)TileEntityKeyboard::new), (Supplier<? extends Block>)BlockInit.blockKeyBoard),
    REMOTE_CONTROLLER("remotectrl", "Remote_Controller", (BlockEntityType.BlockEntitySupplier<? extends BlockEntity>)((BlockEntityType.BlockEntitySupplier)TileEntityRCtrl::new), (Supplier<? extends Block>)BlockInit.blockRControl),
    REDSTONE_CONTROLLER("redstonectrl", "Redstone_Controller", (BlockEntityType.BlockEntitySupplier<? extends BlockEntity>)((BlockEntityType.BlockEntitySupplier)TileEntityRedCtrl::new), (Supplier<? extends Block>)BlockInit.blockRedControl),
    SERVER("server", "Server", (BlockEntityType.BlockEntitySupplier<? extends BlockEntity>)((BlockEntityType.BlockEntitySupplier)TileEntityServer::new), (Supplier<? extends Block>)BlockInit.blockServer);

    private final String name;
    private final String wikiName;
    private final BlockEntityType.BlockEntitySupplier<? extends BlockEntity> teClass;
    private final Supplier<? extends Block> bClass;

    private DefaultPeripheral(String name, String wname, BlockEntityType.BlockEntitySupplier<? extends BlockEntity> factory, Supplier<? extends Block> supplier) {
        this.name = name;
        this.wikiName = wname;
        this.teClass = factory;
        this.bClass = supplier;
    }

    public Supplier<? extends Block> getBlockClass() {
        return this.bClass;
    }

    public static DefaultPeripheral fromMetadata(int meta) {
        if ((meta & 3) == 3) {
            return DefaultPeripheral.values()[(meta >> 2 & 3 | 4) - 1];
        }
        return DefaultPeripheral.values()[meta & 3];
    }

    public BlockEntityType.BlockEntitySupplier<? extends BlockEntity> getTEClass() {
        return this.teClass;
    }

    public boolean hasFacing() {
        return this.ordinal() < 3;
    }

    public int toMetadata(int facing) {
        int ret = this.ordinal();
        ret = ret < 3 ? (ret |= facing << 2) : (ret + 1 & 3) << 2 | 3;
        return ret;
    }

    @NotNull
    public String m_7912_() {
        return "default_peripheral_" + this.name;
    }
}

